% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_encoding_errors.R
\name{int_encoding_errors}
\alias{int_encoding_errors}
\title{Encoding Errors}
\usage{
int_encoding_errors(
  resp_vars = NULL,
  study_data,
  label_col,
  meta_data_dataframe = "dataframe_level",
  item_level = "item_level",
  ref_encs,
  meta_data = item_level,
  meta_data_v2,
  dataframe_level
)
}
\arguments{
\item{resp_vars}{\link{variable} the names of the measurement variables, if
missing or \code{NULL}, all variables will be checked}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data_dataframe}{\link{data.frame} the data frame that contains the
metadata for the data frame level}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{ref_encs}{reference encodings (names are \code{resp_vars})}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{dataframe_level}{\link{data.frame} alias for \code{meta_data_dataframe}}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: \link{data.frame} with information on such problems
\item \code{SummaryData}: \link{data.frame} human readable version of \code{SummaryTable}
\item \code{FlaggedStudyData}: \link{data.frame} tells for each entry in study data if
its encoding is OK. has the same dimensions as
\code{study_data}
}
}
\description{
Detects errors in the character encoding of string variables

\link{Indicator}
}
\details{
Strings are stored based on
\href{https://en.wikipedia.org/wiki/Character_encoding}{code tables}, nowadays,
typically as
\href{https://en.wikipedia.org/wiki/UTF-8}{UTF-8}. However, other code systems
are still in use, so, sometimes, strings from different systems are mixed
in the data. This indicator checks for such problems and returns the count
of entries per variable, that do not match the reference coding system, which
is estimated from the study data (addition of metadata field is planned).

If not specified in the metadata (columns \code{ENCODING} in item- or data-frame-
level, the encoding is guessed from the data). Otherwise, it may be any
supported encoding as returned by \code{iconvlist()}.
}
