% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grafico_comparacion_medios.R
\name{grafico_comparacion_medios}
\alias{grafico_comparacion_medios}
\title{Grafico de comparacion de medios por periodo (Interactivo)}
\usage{
grafico_comparacion_medios(
  datos,
  titulo,
  fecha_inicio = NULL,
  fecha_fin = NULL,
  medios = NULL,
  agrupar_por = "day",
  tema = "light",
  tipo_grafico = "lineas"
)
}
\arguments{
\item{datos}{Data frame con los datos procesados, que debe incluir las columnas `fecha` y `medio`.}

\item{titulo}{Texto que aparecera en el titulo del grafico.}

\item{fecha_inicio}{Fecha de inicio para la construccion del grafico en formato YYYY-MM-DD (opcional).}

\item{fecha_fin}{Fecha de finalizacion para la construccion del grafico en formato YYYY-MM-DD (opcional).}

\item{medios}{Vector de strings con las medios a comparar. Si es NULL, usa todas las medios disponibles.}

\item{agrupar_por}{Cadena de texto que especifica el periodo de agrupacion.
Valores validos son `"day"` (por defecto) o `"month"`.}

\item{tema}{Tema del grafico. Valores validos son `"light"` (por defecto) o `"dark"`.}

\item{tipo_grafico}{Tipo de visualizacion. Valores validos son `"lineas"` (por defecto) o `"barras"`.}
}
\value{
Un grafico plotly interactivo que muestra la comparacion de publicaciones por medio y periodo.
}
\description{
Esta funcion genera un grafico interactivo que compara la cantidad de publicaciones
entre diferentes medios de medios, agrupadas por dia o por mes, con opcion de tema dark o light.
}
\examples{
\dontrun{
# Comparar todas las medios por mes
datos <- extraer_noticias_fecha("delincuencia", "2024-01-01", "2025-01-01", subir_a_bd = FALSE)
grafico_comparacion_medios(datos, titulo = "Cobertura de Delincuencia por Medio",
                            agrupar_por = "month", tema = "dark")

# Comparar medios especificas por dia
grafico_comparacion_medios(datos, titulo = "Comparacion BBCl vs emol",
                            medios = c("bbcl", "emol"),
                            fecha_inicio = "2024-06-01", fecha_fin = "2024-06-30",
                            agrupar_por = "day", tipo_grafico = "barras")
}


}
