% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mushroom}
\alias{mushroom}
\title{Mushroom Species Dataset (Original Format)}
\format{
A data frame with 23 observations and 5 variables:
\itemize{
    \item \code{Species}: Mushroom species name.
    \item \code{Pileus.Cap.Width}: Pileus cap width range (cm).
    \item \code{Stipe.Length}: Stipe length range (cm).
    \item \code{Stipe.Thickness}: Stipe thickness range (cm).
    \item \code{Edibility}: Edibility code (U/Y/N/T).
}
}
\source{
Billard, L. and Diday, E. (2006), Table 3.2.
}
\usage{
data(mushroom)
}
\description{
Interval-valued data for 23 mushroom species of the genus Agaricus
with 3 morphological measurements from the Fungi of California Species.
}
\details{
Classic SDA dataset used for descriptive statistics, histogram
construction, and clustering of interval-valued data.
}
\examples{
data(mushroom)
}
\references{
Billard, L. and Diday, E. (2006). \emph{Symbolic Data Analysis:
Conceptual Statistics and Data Mining}. Wiley, Chichester. Table 3.2.
}
\keyword{datasets}
\keyword{interval}
