% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_samples.R
\name{summarize_waterdata_samples}
\alias{summarize_waterdata_samples}
\alias{summarize_USGS_samples}
\title{USGS Samples Summary Data}
\usage{
summarize_waterdata_samples(monitoringLocationIdentifier)

summarize_USGS_samples(monitoringLocationIdentifier)
}
\arguments{
\item{monitoringLocationIdentifier}{A monitoring location identifier has two parts,
separated by a dash (-): the agency code and the location number. Location identifiers should be separated with commas,
for example: AZ014-320821110580701, CAX01-15304600, USGS-040851385. Location
numbers without an agency prefix are assumed to have the prefix USGS.}
}
\value{
data frame with summary of data available based on the monitoringLocationIdentifier
}
\description{
This function creates the call and gets the data for discrete water quality samples summary data
service described at \url{https://api.waterdata.usgs.gov/samples-data/docs}.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
monitoringLocationIdentifier <- "USGS-04074950"

what_data <- summarize_waterdata_samples(monitoringLocationIdentifier)

}
\dontshow{\}) # examplesIf}
}
