% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plot density}
\usage{
plot_density(
  data,
  label_x = "",
  label_y = "",
  colors = NULL,
  bin = NULL,
  alpha = 0.25
)
}
\arguments{
\item{data}{data.frame with one or more numeric columns}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional fill color (single column) or vector for groups}

\item{bin}{optional bin width passed to \code{geom_density}}

\item{alpha}{fill transparency (0–1)}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Kernel density plot for one or multiple numeric columns.
}
\details{
If \code{data} has multiple numeric columns, densities are overlaid and filled by column (group).
When a single column is provided, \code{colors} (if set) is used as a constant fill.
The \code{bin} argument is passed to \code{geom_density(binwidth=...)}.
}
\examples{
grf <- plot_density(iris |> dplyr::select(Sepal.Width), colors="blue")
plot(grf)
}
