% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sodium.R
\name{key_sodium}
\alias{key_sodium}
\title{Symmetric encryption with sodium}
\usage{
key_sodium(key)
}
\arguments{
\item{key}{A sodium key (i.e., generated with \code{\link[sodium:keygen]{sodium::keygen()}}}
}
\description{
Wrap a sodium symmetric key.  This can be used with the functions
\code{\link[=encrypt_data]{encrypt_data()}} and \code{\link[=decrypt_data]{decrypt_data()}}, along
with the higher level wrappers \code{\link[=encrypt]{encrypt()}} and
\code{\link[=decrypt]{decrypt()}}.  With a symmetric key, everybody uses the
same key for encryption and decryption.
}
\examples{
# Create a new key
key <- cyphr::key_sodium(sodium::keygen())
key

# With this key encrypt a string
secret <- cyphr::encrypt_string("my secret string", key)
# And decrypt it again:
cyphr::decrypt_string(secret, key)
}
