% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpcscore.R
\name{fpcscore}
\alias{fpcscore}
\title{Calculate functional principal component (fpc) scores}
\usage{
fpcscore(Z, nbasis, tt)
}
\arguments{
\item{Z}{An \code{n} by \code{nT} matrix. The recording/measurement matrix of the functional predictor.}

\item{nbasis}{The number of basis functions used for spline approximation.}

\item{tt}{The vector of recording/measurement points for the functional predictor.}
}
\value{
A \code{list} of
     \item{score}{An \code{n} by \code{nbasis} matrix. The estimated functional principal component scores.}
     \item{eigv}{A vector of estimated eigen-values related to FPCA.}
     \item{varp}{A vector of percents of variance explained related to FPCA.}
}
\description{
Conduct functional principal component analysis (FPCA) on the observation matrix of the functional predictor.
}
\examples{
# Generate a recording/measurement matrix of the functional predictor
fddata = matrix(rnorm(1000), nrow = 10, ncol = 100)
tpoints = seq(0, 1, length.out = 100)

library(fda)
# Using 20 basis functions for spline approximation
fpcscore(fddata, nbasis = 20, tt = tpoints)


}
