% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs.R
\name{get_genetox_details}
\alias{get_genetox_details}
\title{Get genetox details}
\usage{
get_genetox_details(
  DTXSID = NULL,
  API_key = NULL,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of genetox detail data related to the input DTXSID.
}
\description{
Get genetox details
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull genetox details for BPA
bpa_genetox_details <- get_genetox_details(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
