% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joins_tidy.R
\name{join}
\alias{join}
\alias{inner_join.csquares}
\alias{left_join.csquares}
\alias{right_join.csquares}
\alias{full_join.csquares}
\alias{semi_join.csquares}
\alias{anti_join.csquares}
\alias{st_join.csquares}
\title{Join \code{csquares} objects using tidyverse conventions}
\usage{
inner_join.csquares(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.csquares(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.csquares(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.csquares(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.csquares(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

anti_join.csquares(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

st_join.csquares(x, y, join, ..., suffix = c(".x", ".y"))
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{Other parameters passed onto methods.}

\item{join}{geometry predicate function with the same profile as \link[sf]{st_intersects}; see details}
}
\description{
When a \code{csquares} object inherits from class \code{data.frame}, you can apply tidyverse
joins to the object (\code{?dplyr::join}). The functions implemented here make sure that
the csquares properties are preserved. The functions should be called via the \code{dplyr}
generics. So load the \code{dplyr} package first, then call the function without the \code{.csquares}
suffix (see examples). When \code{x} inherits from \code{stars}, only \code{left_join} is supported.
}
\examples{
\donttest{
if (requireNamespace(c("sf", "dplyr"))) {
  library(csquares)
  library(sf)
  library(dplyr)
  orca_sf <- orca |> as_csquares(csquares = "csquares") |> st_as_sf()
  right_table <- data.frame(csquares = c("1000:1", "1004:1"), foo = "bar")
  
  orca_join <- left_join (orca_sf, right_table, by = "csquares")
  orca_join <- right_join(orca_sf, right_table, by = "csquares")
  orca_join <- inner_join(orca_sf, right_table, by = "csquares")
  orca_join <- anti_join (orca_sf, right_table, by = "csquares")
  orca_join <- semi_join (orca_sf, right_table, by = "csquares")
  orca_grid <- new_csquares(orca_sf, 5)
  orca_grid <- left_join(orca_grid, orca, by = "csquares")
}
}
}
\author{
Pepijn de Vries
}
