% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_detection_hlm.R
\name{signal_detection_hlm}
\alias{signal_detection_hlm}
\alias{signal_detection_hlm.csfmt_rts_data_v1}
\title{Determine the short term trend of a timeseries}
\usage{
signal_detection_hlm(x, ...)

\method{signal_detection_hlm}{csfmt_rts_data_v1}(
  x,
  value,
  baseline_isoyears = 5,
  remove_last_isoyearweeks = 0,
  forecast_isoyearweeks = 2,
  value_naming_prefix = "from_numerator",
  remove_training_data = FALSE,
  ...
)
}
\arguments{
\item{x}{Data object}

\item{...}{Not in use.}

\item{value}{Character of name of value}

\item{baseline_isoyears}{Number of years in the past you want to include as baseline}

\item{remove_last_isoyearweeks}{Number of isoyearweeks you want to remove at the end (due to unreliable data)}

\item{forecast_isoyearweeks}{Number of isoyearweeks you want to forecast into the future}

\item{value_naming_prefix}{"from_numerator", "generic", or a custom prefix}

\item{remove_training_data}{Boolean. If TRUE, removes the training data (i.e. 1:(trend_isoyearweeks-1)) from the returned dataset.}
}
\value{
The original csfmt_rts_data_v1 dataset with extra columns. *_trend*_status contains a factor with levels c("training", "forecast", "decreasing", "null", "increasing"), while *_doublingdays* contains the expected number of days before the numerator doubles.
}
\description{
The method is based upon a published analytics strategy by Benedetti (2019) <doi:10.5588/pha.19.0002>.
}
\examples{
d <- cstidy::nor_covid19_icu_and_hospitalization_csfmt_rts_v1
d <- d[granularity_time=="isoyearweek"]
res <- csalert::signal_detection_hlm(
  d,
  value = "hospitalization_with_covid19_as_primary_cause_n",
  baseline_isoyears = 1
)
print(res[, .(
  isoyearweek,
  hospitalization_with_covid19_as_primary_cause_n,
  hospitalization_with_covid19_as_primary_cause_forecasted_n,
  hospitalization_with_covid19_as_primary_cause_forecasted_n_forecast,
  hospitalization_with_covid19_as_primary_cause_baseline_predinterval_q50x0_n,
  hospitalization_with_covid19_as_primary_cause_baseline_predinterval_q99x5_n,
  hospitalization_with_covid19_as_primary_cause_n_status
)])
}
