% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/four_square.R
\name{four_square}
\alias{four_square}
\title{Four-Square Cipher}
\usage{
four_square(message, key1, key2, encrypt = TRUE)
}
\arguments{
\item{message}{a character vector used as the plaintext to be encrypted or the ciphertext to be decrypted}

\item{key1}{a character vector used as the encryption key for the first encryption matrix}

\item{key2}{a character vector used as the encryption key for the second encryption matrix}

\item{encrypt}{(Default: \code{TRUE}) TRUE will encrypt the message, while FALSE will decrypt the message.}
}
\value{
A character vector of either plaintext that has been encrypted or ciphertext that has been decrypted.
}
\description{
This can be used to encrypt or decrypt a Four-Square cipher. The Four-Square cipher is a polygraphic
substitution cipher that maps digrams of text to two encryption matrices through their position in a square alphabet matrix.
}
\examples{
four_square("THEPRISONERSHAVEESCAPED", "HACK", "SAFE", encrypt = TRUE)
four_square("SHBOTDTMPFSQDFZSCUHFPBCY", "HACK", "SAFE", encrypt = FALSE)

}
