% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autokey.R
\name{autokey}
\alias{autokey}
\title{Autokey Cipher}
\usage{
autokey(message, key, encrypt = TRUE)
}
\arguments{
\item{message}{A character vector of plaintext to be encrypted or ciphertext to be decrypted}

\item{key}{A character vector to be used as the encryption key}

\item{encrypt}{(Default: \code{TRUE}) TRUE will encrypt the message, while FALSE will decrypt the message.}
}
\value{
A character vector of either plaintext that has been encrypted or ciphertext that has been decrypted.
}
\description{
This can be used to encrypt or decrypt an Autokey cipher. The Autokey Cipher is derived from the Vigenere Cipher,
in which the key and plaintext are bound to generate a new encryption key for the Vigenere method.
This Vigenere method uses only letters and numbers, as such any other characters used as inputs are not used in the cipher.
}
\examples{
autokey("VerySecretMessage", "Hack", encrypt = TRUE)
autokey("c4JYn8JfwNoLMbmAM", "Hack", encrypt = FALSE)
autokey("Very $\%^&SecretMes(*sag£$\%e", "Hack", encrypt = TRUE)

}
