% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cif.R
\name{readCIF}
\alias{readCIF}
\title{Reads and output a CIF file}
\usage{
readCIF(filename, message = FALSE)
}
\arguments{
\item{filename}{A character string. The path to a valid CIF file.}

\item{message}{A logical variable. If TRUE (default) the function prints
a message highlighting what is included in the cif file.}
}
\value{
A named list. Each name correspond to a valid field in the cif.
}
\description{
Reads and output a CIF file
}
\examples{
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"AMS_DATA.cif")
lCIF <- readCIF(filename)
print(names(lCIF))
print(lCIF$INTRO$CELL)
print(lCIF$INTRO$HALL)
print(lCIF$INTRO$HM)
print(lCIF$SYMM)

}
