% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{obs_for_eval}
\alias{obs_for_eval}
\title{Internal: indices used for target evaluation}
\usage{
obs_for_eval(eval_token, K, fold_idx, plan)
}
\arguments{
\item{eval_token}{An evaluation token created by
\code{\link{make_eval_token}}.}

\item{K}{Total number of folds.}

\item{fold_idx}{A list mapping fold labels \code{1:K} to integer row
indices in \code{data}.}

\item{plan}{The cross-fitting plan as returned by
\code{build_instances()}.}
}
\value{
A list with components \code{idx} (row indices) and
\code{folds} (fold labels).
}
\description{
Given an evaluation token and the cross-fitting plan, returns the row
indices and fold labels used to evaluate the target model for that
panel. The evaluation window has width \code{plan$eval_width[mi]} and
is wrapped cyclically on \code{K} folds.
}
\keyword{internal}
