% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{load_structure}
\alias{load_structure}
\title{Load 1D structure data in workspace.}
\usage{
load_structure(sname = NULL)
}
\arguments{
\item{sname}{A character string. Name of the structure whose data
are to be loaded in the workspace. It can be one of:
\itemize{
  \item{beryllium_fluoride}
  \item{carbon_dioxide}
  \item{cyanate}
  \item{nitronium}
  \item{thiocyanate}
  \item{xenon_difluoride}
  \item{pinkerton2015}
}
Default is NULL, in which case the function returns a list of all
structures available.}
}
\value{
A named list with the following elements:
 \itemize{
   \item{a    Real numeric. Unit cell length in angstroms.}
   \item{SG   2-letters character string. There are only two symmetries
               possible when working within 1D crystallography, P1 (no 
               symmetry) and P-1 (inversion through the origin). SG can be 
               either "P1" or "P-1".}
   \item{x0    Vector of real numerics indicating the expanded atomic
                positions in the unit cell.}
   \item{Z     Vector of integers indicating the expanded 
                atomic numbers for all atoms in the unit cell.}
   \item{B    Vector of real numerics indicating the expanded 
               B factors for all atoms in the unit cell.}
   \item{occ  Vector of real numerics indicating the expanded 
               occupancies for all atoms in the unit cell.}
         }
}
\description{
Function to load data from one of the many 1D structures available
within the \emph{crone} package.
}
\examples{
# Load thiocyanate data
sdata <- load_structure("thiocyanate")
print(sdata)

# Default returns all names of structures included
load_structure()

}
