% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-validity.R
\name{v_cohort_size}
\alias{v_cohort_size}
\alias{v_cohort_size_range}
\alias{v_cohort_size_dlt}
\alias{v_cohort_size_const}
\alias{v_cohort_size_parts}
\alias{v_cohort_size_max}
\title{Internal Helper Functions for Validation of \code{\link{CohortSize}} Objects}
\usage{
v_cohort_size_range(object)

v_cohort_size_dlt(object)

v_cohort_size_const(object)

v_cohort_size_parts(object)

v_cohort_size_max(object)
}
\arguments{
\item{object}{(\code{CohortSize})\cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{CohortSize}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_cohort_size_range()}: validates that the \code{\link{CohortSizeRange}} object
contains valid \code{intervals} and  \code{cohort_size} slots.

\item \code{v_cohort_size_dlt()}: validates that the \code{\link{CohortSizeDLT}} object
contains valid \code{intervals} and  \code{cohort_size} slots.

\item \code{v_cohort_size_const()}: validates that the \code{\link{CohortSizeConst}} object
contains valid \code{size} slot.

\item \code{v_cohort_size_parts()}: validates that the \code{\link{CohortSizeParts}} object
contains valid \code{sizes} slot.

\item \code{v_cohort_size_max()}: validates that the \code{\link{CohortSizeMax}} object
contains valid \code{cohort_sizes} slot.

}}
