% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stock_and_yogo.R
\name{stock_yogo_test}
\alias{stock_yogo_test}
\title{Perform the Stock and Yogo test for weak instruments}
\usage{
stock_yogo_test(X, D, Z, data, B = 0.05, size_bias = "bias")
}
\arguments{
\item{X}{(formula). A one-sided formula of control variables.}

\item{D}{(formula). A one-sided formula of endogenous variables (treatments)}

\item{Z}{(formula). A one-sided formula of instruments}

\item{data}{(dataframe). An optional dataframe, list, or environment
containing the variables used in the model. As with many of the base R
functions, if the variables are not found here, they may be searched for in
the environment cragg_donald() was called.}

\item{B}{One of [.05, .1, .15, .2, .25, .3]. The maximum size of allowable bias relative}

\item{size_bias}{Either "bias" or "size". Whether to use a critical
value based on the maximum allowable bias relative to regular OLS (bias), or maximum
Wald test size distortion (size).}
}
\value{
(sy_test) the results of the stock and yogo test.
}
\description{
Perform the Stock and Yogo test for weak instruments
}
\examples{
#Perform the Stock and Yogo test on a model that instruments
#Sepal Width on Petal Length, Petal Width, and Species, while controlling
#for Sepal.Length (a toy example).

stock_yogo_test(X=~Sepal.Length, D=~Sepal.Width,
	Z=~Petal.Length + Petal.Width + Species,
	size_bias="bias",data = iris)

}
