% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbarplot.R
\name{cbarplot}
\alias{cbarplot}
\title{Circular Bar Plot}
\usage{
cbarplot(
  x,
  nbins = 36,
  radius = 1/sqrt(base::pi),
  prob = TRUE,
  nlabels = 4,
  col = NULL,
  border = NULL,
  m = NA,
  xlim = NULL,
  ylim = NULL,
  main = NULL
)
}
\arguments{
\item{x}{a numeric vector storing angular values between 0 and 2 pi, or
an object that can be coerced to.}

\item{nbins}{the number of bins of the circular bar plot. Internally, it
is rounded to a multiple of 4.}

\item{radius}{the radius of the reference circle.}

\item{prob}{logical; if \code{TRUE}, the circular histogram graphic is a
representation of probability densities; if \code{FALSE}, a
representation of frequencies.}

\item{nlabels}{integer, for the number of levels to be plotted; if
\code{0}, no label is plotted}

\item{col}{the color to fill the bars.}

\item{border}{the color of the border around the bars.}

\item{m}{the number of points within each bin to plot the top of a
bar. The larger the number is, the smoother the plot looks.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates
ranges.}

\item{ylim}{numeric vectors of length 2, giving the y coordinates
ranges.}

\item{main}{the main title (on top)}
}
\value{
No return value
}
\description{
Function \code{cbarplot} can be used to plot 2-dimensional 
  circular bar plots. The circular bar plots can only adopt the 
  height-proportional transformation because of the white space between bars.
}
\examples{
# 600 observations from two von Mises distributions
library(circular)
x = c(rvonmises(200, circular(pi/4), 5), rvonmises(400, circular(pi), 20))

cbarplot(x)                     
cbarplot(x, prob=FALSE)
cbarplot(x, radius=1, nlabels=0, col="lightblue")
cbarplot(x, radius=1, col="lightblue", border="skyblue4")

}
\references{
Xu, D. and Wang, Y. (2020). Area-proportional Visualization for
Circular Data. \emph{Journal of Computational and Graphical
Statistics}, \bold{29}, 351-357.
}
\seealso{
\code{\link{cdensity}}, \code{\link{cdotplot}}, \code{\link{chist}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\concept{circular bar plot}
