% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_csss_data.R
\name{update_csss_data}
\alias{update_csss_data}
\title{Update COVID Symptom Study Sweden (CSSS) data}
\usage{
update_csss_data(silence = FALSE)
}
\arguments{
\item{silence}{A logical parameter (default FALSE) to suppress messages. Setting this parameter will not affect the functionality now as the function does not perform any operations.}
}
\value{
None. This function now simply prints a message to the console indicating that the function has been disabled and no updates are available.
}
\description{
Originally, this function would update the package datasets in the global environment with the most recent data from the development version of the package. However, as updates to the CSSS dataset have been discontinued, this function now simply notifies that no updates are available.

This function served to ensure that the package datasets remained up-to-date without requiring a full package reinstallation. It would compare the local version of the data with the latest online version and offer to update if newer data were found.

Due to the discontinuation of data updates from CSSS, this function now only serves to inform users that no new updates will be provided, preserving its structure for educational or demonstration purposes.
}
\examples{
update_csss_data() # This will print a message that no updates are available.
}
\author{
Hugo Fitipaldi
}
