% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{total_b2020}
\alias{total_b2020}
\title{COVID-19 data for total age/sex in Norway (2020 border).}
\format{
\describe{
\item{granularity_time}{Time granularity: day, isoyearweek}
\item{granularity_geo}{Geographical granularity: nation, county, municip}
\item{location_code}{Location code}
\item{border}{Redistricting border: 2020}
\item{age}{Age category: total}
\item{sex}{Sex category: total}
\item{isoyear}{Isoyear}
\item{isoweek}{Isoweek}
\item{isoyearweek}{Isoyearweek}
\item{season}{Season}
\item{seasonweek}{Season week}
\item{calyear}{Calendar year}
\item{calmonth}{Calendar month}
\item{date}{Date}
\item{cases_by_testdate_n}{Number of cases by date of PCR test}
\item{cases_by_testdate_vs_pop_pr100000}{Number of cases by date of PCR test per 100.000 population}
\item{cases_by_regdate_n}{Number of cases by date of registration in MSIS}
\item{cases_by_regdate_vs_pop_pr100000}{Number of cases by date of registration in MSIS per 100.000 population}
\item{icu_admissions_n}{Number of ICU admissions}
\item{hospital_admissions_main_cause_n}{Number of hospital admissions with COVID-19 as the main cause}
\item{testevents_neg_n}{Number of testing events (all tests of one person within a 7 day period are considered to be one testing event) that were negative}
\item{testevents_pos_n}{Number of testing events (all tests of one person within a 7 day period are considered to be one testing event) that were positive}
\item{testevents_all_n}{Number of testing events (all tests of one person within a 7 day period are considered to be one testing event)}
\item{testevents_pos_vs_all_pr100}{Percent of testing events that were positive}
\item{vax_dose_1_by_vaxdate_n}{Number of dose 1 vaccines delivered by date of vaccination}
\item{vax_dose_2_by_vaxdate_n}{Number of dose 2 vaccines delivered by date of vaccination}
\item{vax_dose_3_by_vaxdate_n}{Number of dose 3 vaccines delivered by date of vaccination}
\item{vax_dose_4_by_vaxdate_n}{Number of dose 4 vaccines delivered by date of vaccination}
\item{vax_dose_1_by_vaxdate_sum0_999999_n}{Cumulative number of dose 1 vaccines delivered by date of vaccination}
\item{vax_dose_2_by_vaxdate_sum0_999999_n}{Cumulative number of dose 2 vaccines delivered by date of vaccination}
\item{vax_dose_3_by_vaxdate_sum0_999999_n}{Cumulative number of dose 3 vaccines delivered by date of vaccination}
\item{vax_dose_4_by_vaxdate_sum0_999999_n}{Cumulative number of dose 4 vaccines delivered by date of vaccination}
\item{vax_dose_1_by_regdate_n}{Number of dose 1 vaccines delivered by date of registration in SYSVAK}
\item{vax_dose_2_by_regdate_n}{Number of dose 2 vaccines delivered by date of registration in SYSVAK}
\item{vax_dose_3_by_regdate_n}{Number of dose 3 vaccines delivered by date of registration in SYSVAK}
\item{vax_dose_4_by_regdate_n}{Number of dose 4 vaccines delivered by date of registration in SYSVAK}
\item{pop_jan1_n}{Population as per first of January}
\item{location_name}{Location name (may not be unique)}
\item{location_name_description_nb}{Location name description (is unique)}
}
}
\usage{
total_b2020
}
\description{
This dataset contains COVID-19 data in Norway,
from 2020 week 8 (2020-02-23) to 2022 week 45 (2022-11-13)
}
\examples{
print(covidnor::total_b2020[1,])

}
\keyword{datasets}
