% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19_plts.R
\name{totals.plt}
\alias{totals.plt}
\title{function to plot total number of cases per day for different groups}
\usage{
totals.plt(
  data0 = NULL,
  geo.loc0 = NULL,
  one.plt.per.page = FALSE,
  log.plt = TRUE,
  with.totals = FALSE,
  interactive.fig = TRUE,
  fileName = NULL,
  interactive.display = TRUE
)
}
\arguments{
\item{data0}{time series dataset to process, default all the possible cases: 'confirmed' and 'deaths' for all countries/regions}

\item{geo.loc0}{geographical location, country/region or province/state to restrict the analysis to}

\item{one.plt.per.page}{boolean flag to have one plot per figure}

\item{log.plt}{include a log scale plot in the static plot}

\item{with.totals}{a boolean flag to indicate whether the totals should be displayed with the records for the specific location}

\item{interactive.fig}{switch to turn off/on an interactive plot}

\item{fileName}{file where to save the HTML version of the interactive figure}

\item{interactive.display}{boolean argument for enabling or not displaying the interactive figure}
}
\description{
function to plot total number of cases per day for different groups
}
\examples{
# retrieve time series data
TS.data <- covid19.data("ts-ALL")

# static and interactive plot 
totals.plt(TS.data)


}
