% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulated_annealing_MI.R
\name{simulated_annealing_MI}
\alias{simulated_annealing_MI}
\title{Simulated Annealing Algorithm with Target Entropy Stopping Condition}
\usage{
simulated_annealing_MI(
  initial_table,
  obj,
  gen_fn,
  target,
  max_n = 5000,
  temp = 10,
  maxim = TRUE,
  readj = FALSE
)
}
\arguments{
\item{initial_table}{A contingency table to start the optimization.}

\item{obj}{An objective function that calculates the value to be optimized (e.g., entropy, mutual information).}

\item{gen_fn}{A function that generates a new table based on the current table.}

\item{target}{The target value for the objective function (e.g., target entropy).}

\item{max_n}{The maximum number of iterations to run the algorithm (default is 5000).}

\item{temp}{The initial temperature for the simulated annealing process (default is 10).}

\item{maxim}{Logical: Should the algorithm maximize (TRUE) or minimize (FALSE) the objective function (default is TRUE).}

\item{readj}{Logical: If TRUE, the algorithm is in a readjusting state (default is FALSE).}
}
\value{
A list containing:
\itemize{
\item \code{best}: The best table found during the optimization process.
\item \code{best_eval}: The best evaluation value (objective function value).
\item \code{n}: The number of iterations completed.
\item \code{mutual_info_history}: A data frame with the history of mutual information values (or objective function values)
during each iteration.
}
}
\description{
This function performs simulated annealing to optimize a given objective (entropy, mutual information, etc.)
using a given table modification function. The optimization stops once the target entropy is reached or
after a maximum number of iterations.
}
\examples{
# Example of using simulated annealing for entropy maximization:
initial_table <- matrix(c(5, 3, 4, 2), nrow = 2, ncol = 2)
obj <- entropy_pair  # Example entropy function
gen_fn <- gen_number_max  # Example generation function
target <- 0.5
result <- simulated_annealing_MI(initial_table, obj, gen_fn, target)

}
