% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_number_1.R
\name{gen_number_1}
\alias{gen_number_1}
\title{Generate a New Number for Stepwise Modification}
\usage{
gen_number_1(x)
}
\arguments{
\item{x}{A contingency table (numeric matrix or table).}
}
\value{
A modified contingency table with stepwise adjustments.
}
\description{
This function modifies a given contingency table by swapping values between two cells
in a stepwise manner, where the change is fixed at a \code{delta} value of 1. The function
randomly selects two cells from the table and adjusts their values by subtracting and
adding the \code{delta} value.
}
\details{
This function performs the following steps:
\enumerate{
\item Randomly selects two rows and two columns from the table.
\item Ensures that the selected cells have non-zero values.
\item Adjusts the values of the selected cells by subtracting 1 from two cells and
adding 1 to the other two.
\item Returns the modified table with stepwise adjustments.
}
}
\examples{
# Example usage with a contingency table:
pair_table <- table(c(1, 2, 2, 3), c(1, 1, 2, 2))
gen_number_1(pair_table)

}
