% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nlmeBM.R
\name{nlmeBM}
\alias{nlmeBM}
\title{nlmeBM}
\usage{
nlmeBM(model, data, fixed, random, start, covariance = NULL,
  method = c("ML", "REML"), control = list(), verbose = FALSE)
}
\arguments{
\item{model}{This is as specified for \code{\link[nlme]{nlme.formula}}.}

\item{data}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{fixed}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{random}{This is as specified for \code{\link[nlme]{nlme.formula}}.}

\item{start}{This is as specified for \code{\link[nlme]{nlme.formula}}.}

\item{covariance}{An optional \code{\link[nlme]{corStruct}} object describing the within-group
covariance structure. In addition to those available in \code{nlme},
\code{\link{covBM}} can be used to incorporate a Brownian motion component, \code{\link{covFracBM}}
can be used to incorporate a fractional Brownian motion component and \code{\link{covIOU}}
can be used to incorporate an integrated Ornstein-Uhlenbeck process in relation to
a continuous variable.}

\item{method}{This is as specified for \code{\link[nlme]{lme.formula}}.}

\item{control}{This is as specified for \code{\link[nlme]{nlme.formula}}.}

\item{verbose}{This is as specified for \code{\link[nlme]{nlme.formula}}.}
}
\value{
An object of class "nlme" and inheriting from class "lme" representing the non-linear mixed effects model fit.
}
\description{
This function is a wrapper for \code{\link[nlme]{nlme.formula}} that allows
Brownian motion, fractional Brownian motion or integrated Ornstein-Uhlenbeck
components to be included in non-linear mixed models, with related parameter
estimates and confidence intervals returned in their natural parameterisation.
}
\examples{
data(Milk, package="nlme")
Model_fit<- nlmeBM(protein ~ SSasymp(Time, Asym, R0, lrc), data=Milk,
				fixed = Asym + R0 + lrc ~ 1, random = Asym ~ 1|Cow,
				covariance=covFracBM(form=~Time|Cow),
        		start = c(Asym = 3.5, R0 = 4, lrc = -1))
}

