% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_score.R
\name{PlotGeneCounts}
\alias{PlotGeneCounts}
\title{Generate a strip plot for counts across selected genes}
\usage{
PlotGeneCounts(C, gene_indices, colors = color_palette)
}
\arguments{
\item{C}{countland object}

\item{gene_indices}{vector of gene index values}

\item{colors}{color palette for ggplot2, default=palette of 11 colors}
}
\value{
generates plot of gene count distributions
}
\description{
Generate a strip plot for counts across selected genes
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
PlotGeneCounts(C,gene_indices=1:10)
}
