% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CounterfactualMethod.R
\name{CounterfactualMethod}
\alias{CounterfactualMethod}
\title{Base class for Counterfactual Explanation Methods}
\description{
Abstract base class for counterfactual explanation methods.
}
\section{Inheritance}{

Child classes: \link{CounterfactualMethodClassif}, \link{CounterfactualMethodRegr}
}

\references{
Dandl, S., Hofheinz, A., Binder, M., Bischl, B., & Casalicchio, C. (2025). "counterfactuals: An R Package for Counterfactual Explanation Methods". Journal of Statistical Software, 115(9), 1–48. doi:10.18637/jss.v115.i09
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CounterfactualMethod-new}{\code{CounterfactualMethod$new()}}
\item \href{#method-CounterfactualMethod-print}{\code{CounterfactualMethod$print()}}
\item \href{#method-CounterfactualMethod-clone}{\code{CounterfactualMethod$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethod-new"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethod-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{CounterfactualMethod} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethod$new(
  predictor,
  lower = NULL,
  upper = NULL,
  distance_function = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{lower}}{(\code{numeric()} | \code{NULL})\cr
Vector of minimum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{lower} is taken as its minimum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{upper}}{(\code{numeric()} | \code{NULL})\cr
Vector of maximum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{upper} is taken as its maximum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{distance_function}}{(\code{character(1)} | \verb{function()})\cr
Either the name of an already implemented distance function
(currently 'gower' or 'gower_c') or a function having three arguments:
\code{x}, \code{y}, and \code{data}. The function should return a \code{double} matrix with
\code{nrow(x)} rows and maximum \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethod-print"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethod-print}{}}}
\subsection{Method \code{print()}}{
Prints a \code{CounterfactualMethod} object.
The method calls a (private) \verb{$print_parameters()} method which should be implemented by the leaf classes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethod$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethod-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethod-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethod$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
