% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrBarplot.R
\name{corrBarplot}
\alias{corrBarplot}
\title{corrBarplot}
\usage{
corrBarplot(
  mat,
  interactive = TRUE,
  pal = colorRampPalette(c("cornflowerblue", "white", "tomato"))(100)
)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{interactive}{A logical value specifying whether to create an interactive ggplotly plot,
default is TRUE}

\item{pal}{A colour palette for the bar plot, default is colorRampPalette(c("cornflowerblue", "white", "tomato"))(100).}
}
\value{
A static or interactive bar plot displaying correlations.
}
\description{
This function creates a either a static or interactive
bar plot of correlations between variables in a dataset.
}
\details{
Creates a static or interactive bar plot displaying correlation values. By hovering
mouse over a bar, the variables and correlation value is shown.
}
\examples{
cm <- cor(mtcars)

corrBarplot(mat = cm,
           interactive = TRUE)


}
