% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animSolar.R
\name{animSolar}
\alias{animSolar}
\title{animSolar}
\usage{
animSolar(
  mat,
  sun = NULL,
  export = FALSE,
  num_frames = 100,
  path = NULL,
  gif_name = "solar_system.gif",
  fps = 60
)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{sun}{A character string specifying the column name in the dataset to be treated
as the 'sun' in the solar system plot.}

\item{export}{A logical value specifying whether to export the animation as a GIF file, default is FALSE.}

\item{num_frames}{An integer specifying the number of frames in the animation, default is 100.}

\item{path}{A character string specifying the directory path where the GIF file will be saved, default is NULL.}

\item{gif_name}{A character string specifying the name of the GIF file. Must be in the format "myFile.gif"}

\item{fps}{An integer specifying the frames per second for the animation.
Default is 60 and is only used when exporting a gif via \code{export = TRUE}.}
}
\value{
An animated solar system plot displaying correlations.
}
\description{
This function creates an animated solar system plot of correlations between
variables in a dataset.
}
\details{
In a solar system correlation plot, the dependent variable of
interest is positioned at the center, represented as the sun.
The explanatory variables are depicted as planets orbiting
around the sun, with their distance from the sun corresponding
to the absolute value of their correlation with the dependent variable.
Therefore, the greater the distance of a planet from the sun,
the weaker the correlation between the explanatory variable
and the dependent variable.

The \code{num_frames} argument is used to select the number of frames.
Setting this to a low value will produce the plot
quicker, however having a low number of frames will result in the "planets" jumping
as the frames transition. Additionally, a low values of   \code{num_frames} will affect the
orbit of the animation when setting \code{export = FALSE}. This differs from the
\code{fps} argument which sets the number of frames to play per second for use
when exporting a gif.
}
\examples{
cm <- cor(mtcars)

animSolar(mat = cm,
          sun = 'mpg',
          export = FALSE,
          num_frames = 25)

}
