% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{predict.copulareg}
\alias{predict.copulareg}
\title{predict}
\usage{
\method{predict}{copulareg}(object, new_x = NULL, eps = 0.01, cont_method = "Localmedian", ...)
}
\arguments{
\item{object}{Model fit as returned by copulareg}

\item{new_x}{optional matrix of covariate values to compute the predicted
values of the outcome for. If not specified, the predicted values for the
training sample is returned.}

\item{eps}{Interval between each interpolation point when integrating to
evaluate the predicted value of y, in the case where y is continuous. If
y is discrete this parameter is ignored.}

\item{cont_method}{Specifies the method used to compute the expected
values. Can be specified as 'Localmedian' or 'Trapezoidalsurv'. The
first method divides the range of the observed values of y into
subintervals according to the argument 'eps', where the sub-integral
is approximated as the measure of the interval weighted by the local
median on the interval. The second method computes the integral by
integrating the survival function using the trapezoidal rule, by
transforming the outcome into a positive variable by adding a constant.}

\item{...}{unused.}
}
\value{
A vector of predicted y-values for each row of new_x, or for the training
data if new_x is not supplied.
}
\description{
Computes predictions based on a fitted copulareg model.
}
