% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqresp.R
\name{ltifr}
\alias{ltifr}
\title{LTI frequency response kernel}
\usage{
ltifr(A, B, w)
}
\arguments{
\item{A}{State-space matrix, A}

\item{B}{State-space input-matrix, B. B must have as many rows as the matrix A.}

\item{w}{Vector of complex frequencies}
}
\value{
Returns the frequency response in vector. \code{\link{freqresp}} utilizes this function for state-space systems.
}
\description{
This function computes the frequency
response of the following system:

   g(w) = (wI-A) \ B

for the complex frequencies contained in the vector W. The column
vector B must have as many rows as the matrix A.
}
\examples{
## use \\code{\\link{freqresp}}

}
\seealso{
\code{\link{freqresp}}
}
