% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_coercion_messages.R
\name{.warn_if_onelevel}
\alias{.warn_if_onelevel}
\title{Warn if one level factor}
\usage{
.warn_if_onelevel(
  one_level_factors = NULL,
  model_data = NULL,
  attempting_factors = NULL
)
}
\arguments{
\item{one_level_factors}{Character vector of which factors are one level}

\item{model_data}{Model data to look for factor columns}

\item{attempting_factors}{Factor column names to check}
}
\value{
Nothing, warns if factors with only one level are detected.
}
\description{
Factors with only one level happen if a character vector is converted to a
factor using \code{factor()} but without specifying anything for the \code{levels}
parameter. If you try to access or set the contrasts for a one-level factor,
you'll get an error that contrasts are undefined because you have 0 degrees
of freedom.
}
\keyword{internal}
