% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_method.R
\name{find_method}
\alias{find_method}
\title{Identify Most Suitable Methods for Conservation Prioritization}
\usage{
find_method(ranking = "both", weights = NULL)
}
\arguments{
\item{ranking}{character string. The methods used for ranking the methods. See details. One of "both", "strict", "inclusive". Default = "both".}

\item{weights}{named list. Provide numeric values to weight questions differently. See details.}
}
\value{
a data.frame containing potentially suitable spatial conservation prioritization
methods order by goodness of fit according to the user-selected algorithm (best fit on top).
Furthermore prints the three most suitable methods to screen.
}
\description{
Identifies suitable methods for conservation prioritization based on a user dialogue on conservation targets and data availability.
}
\details{
Based on the \code{ranking} argument, the conservation prioritization methods in the database are
ranked according to the user-provided information. If ranking = "strict" methods receive
one point for each full agreement with user reply (yes and no), if ranking = "inclusive",
methods get one point when they include a feature confirmed by the user (but non for not including it).
This means that ranking = "inclusive" will  likely return more general methods
that can include many different types of data and perspectives. If ranking = "both",
methods are first ranked as in strict and then equal ranks split by the inclusive ranking.

The \code{weight} argument allows to change the weighting of individual questions relative to the others.
The names of the list follow \code{names(traits)}, from \dQuote{scale} (for question 1) to
\dQuote{includes_simulation} (for question 17). The weights may include any numbers of questions.
See examples
}
\examples{
\dontrun{
find_method()
#double weight to question 3 and 15
find_method(weights = list(phylogeny = 2, vulnerability = 2))
}

}
