% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildHierarchy.R
\name{buildHierarchy}
\alias{buildHierarchy}
\title{Generate hierarchical data}
\usage{
buildHierarchy(type, splits, numOfLevels)
}
\arguments{
\item{type}{A string. In its current state, this is only a placeholder function and is not mandatory. Currently, only one type of hierarchy is permitted namely \eqn{equalSplit}.}

\item{splits}{A positive number. This specifies the number of splits at each branch. For instance, if \eqn{split} is 2 then, each branch will have 2 sub-branches.}

\item{numOfLevels}{A positive number. This specifies the number of layers in the hierarchy.}
}
\value{
A dataframe.
}
\description{
Generates hierarchical data by using an internal function \code{\link{genTree}}. For a working example, please see the vignette.
}
\details{
This function helps in generating hierarchical data. If there are multiple categorical variables i.e. classes that are mapped to other classes in a hierarchical manner, this function helps in building the same. Some common use cases for this type of data are Linnaean system of classification in life sciences and product hierarchy in retail industry.
The number of terminal nodes are dependent on the arguments \eqn{splits} and \eqn{numOfLevels}. More precisely, the number of terminal nodes has the formulation of \eqn{splits^numOfLevels}. For instance, if \eqn{splits} is 2 and \eqn{numOfLevels} is 3, then the number of terminal nodes are \eqn{2^3} i.e. 8. Furthermore, the number of columns of the output dataframe is equal to the \eqn{numOfLevels}. Although a hierarchical data sctructure is often represented as a tree structure, this function outputs the data in a denormalized form i.e a dataframe.
}
\examples{
productHierarchy <- buildHierarchy(type = "equalSplit", splits = 2, numOfLevels = 3)
productHierarchy <- buildHierarchy(splits = 2, numOfLevels = 3)
}
