% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/house_requirement.R
\name{cong_house_requirement}
\alias{cong_house_requirement}
\title{Request House Requirement data}
\usage{
cong_house_requirement(
  number = NULL,
  item = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{number}{Requirement's assigned number. Numeric.}

\item{item}{Information to request. Can be  \code{'matching-communications'}.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
a \code{tibble::tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request House Requirement data
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_house_requirement()

cong_house_requirement(number = 12478)

cong_house_requirement(number = 8070, 'matching-communications')
\dontshow{\}) # examplesIf}
}
