% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var.R
\name{get_var}
\alias{get_var}
\title{Retrive the value of the variable}
\usage{
get_var(
  config = NULL,
  var_name = NULL,
  path = NULL,
  default = structure("UNDEFINED_", class = "UNDEFINED_"),
  cast = NULL
)
}
\arguments{
\item{config}{an object returned by the \code{init_config} function.
If NULL, the config will be evaluated from the path argument.}

\item{var_name}{the variable of interest}

\item{path}{the path from where config files are searched for. If NULL,the
current directory will be considered as default.}

\item{default}{a default value}

\item{cast}{Either a function or a type of cast. Currently implemented
options are `integer`,  `boolean` or `float`.}
}
\value{
The value associated to the config variable. The type depends on
the cast argument. Default is string.
}
\description{
Get a variable from, in order of priority, environment
variable, .env or settings.ini, or default values. Data type can be
cast to boolean or integer.
}
\examples{
config <- get_config()
get_var(config, "test", default = "yes", cast = "bool")
}
