% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staff_member.R
\name{staff_member}
\alias{staff_member}
\title{Create staff member}
\usage{
staff_member(
  id,
  name,
  description,
  external_link,
  internal_link = FALSE,
  email = NA
)
}
\arguments{
\item{id}{String defining the unique identifier for a staff member.}

\item{name}{Display name of staff member.}

\item{description}{Short description, used on staff pages.}

\item{external_link}{Link to an external website.}

\item{internal_link}{Should an internal link be used? TRUE/FALSE}

\item{email}{email address for the staff member. Used to pre-fill the templates.}
}
\value{
An object of class \code{staff_member} with the following elements:
\itemize{
\item \code{id}
\item \code{name}
\item \code{description}
\item \code{external_link}
\item \code{internal_link}
\item \code{email}
}
}
\description{
Creates a staff member for use in an academic group website. On the list of
all staff members (by default in \code{staff_list.Rmd}), the \code{name} and
\code{description} will be reported. In addition, an image, stored in
\code{images/staff} with filename \code{id.png} will be shown.
}
\details{
The external link will be the link in the "MORE" button on the rendered website.
}
\examples{
example_staff_member <- staff_member(
     id = "example-id",
     name = "Example Name",
     description = "Example description for example staff member.",
     external_link = "http://www.example.com/",
     internal_link = FALSE
 )
}
