% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condtMVN.R
\name{condtMVN}
\alias{condtMVN}
\title{Conditional Truncated Multivariate Normal Parameters}
\usage{
condtMVN(
  mean,
  sigma,
  lower,
  upper,
  dependent.ind,
  given.ind,
  X.given,
  init = rep(0, length(mean))
)
}
\arguments{
\item{mean}{the mean vector for Z of length of n}

\item{sigma}{the symmetric and positive-definite covariance matrix of dimension n x n of Z.}

\item{lower}{a vector of lower bounds of length n that truncate Z}

\item{upper}{a vector of upper bounds of length n that truncate Z}

\item{dependent.ind}{a vector of integers denoting the indices of dependent variable Y.}

\item{given.ind}{a vector of integers denoting the indices of conditioning variable X.  If specified as integer vector of length zero or left unspecified, the unconditional density is returned.}

\item{X.given}{a vector of reals denoting the conditioning value of X. This should be of the same length as \code{given.ind}}

\item{init}{initial value used for random generation of truncated multivariate normal in a Gibbs sampler. Default: A vector of zeros, equal to the number of components. For details, see tmvmixnorm::\code{\link[tmvmixnorm]{rtmvn}}().}
}
\value{
Returns a list of: \itemize{
\item condMean - conditional mean of \strong{Y|X}
\item condVar - conditional variance of \strong{Y|X}
\item condLower - the lower bound of \strong{Y|X}
\item condUpper - the upper bound of \strong{Y|X}
\item condInit - the initial values adjusted to match the dimension of \strong{Y|X}. These are used to randomly generate the truncated multivariate normal \link{rcmvtruncnorm}.
}
}
\description{
Suppose that \strong{Z = (X,Y)} is from a fully-joint multivariate normal distribution of dimension \emph{n} with \code{mean} and covariance matrix \code{sigma} truncated between \code{lower} and \code{upper}. This function provides the parameters for the conditional mean and covariance matrix of \strong{Y} given \strong{X}. See the vignette for more information.
}
\details{
The first four arguments are the parameters of multivariate normal and the truncation space. \code{dependent.ind, given.ind, X.given, init} are all arguments that determines the conditional truncated MVN.

Using the full data \strong{Z}, the conditional mean and conditional variance of \strong{Y|X} are determined (Wang, 2006). Additionally, to reflect the reduced dimension of \strong{Y|X}, the truncation limits are also adjusted.

See the vignette for more information.
}
\note{
This function is based on \code{\link[condMVNorm]{condMVN}} from the \strong{condMVNorm} package.
}
\examples{
# Suppose X2,X3,X5|X2,X4 ~ N_3(1, Sigma) and truncated between -10 and 10.
d <- 5
rho <- 0.9
Sigma <- matrix(0, nrow = d, ncol = d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

# Conditional Truncated Normal Parameters
condtMVN(mean = rep(1, d),
  sigma = Sigma,
  lower = rep(-10, d),
  upper = rep(10, d),
  dependent.ind = c(2, 3, 5),
  given.ind = c(1, 4), X.given = c(1, -1)
)
}
\references{
Wang, R. 2006. Appendix A: Marginal and conditional distributions of multivariate normal distribution. \url{http://fourier.eng.hmc.edu/e161/lectures/gaussianprocess/node7.html}.
}
\seealso{
\code{\link[condMVNorm]{cmvnorm}}, \code{\link[mvtnorm]{pmvnorm}}, \code{\link[mvtnorm]{Mvnorm}}
}
