% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose}
\alias{compose}
\title{Compose Multiple Solvers Sequentially}
\usage{
compose(...)
}
\arguments{
\item{...}{Solver functions to compose}
}
\value{
A new solver function that runs all solvers in sequence
}
\description{
Chains any number of solvers sequentially. Each solver's result becomes
the starting point for the next. Alternative to using \code{\%>>\%} operator.
}
\details{
Trace data from all solvers is merged into a single trace with stage
boundaries preserved.
}
\examples{
\donttest{
set.seed(42)
x <- rnorm(50, 5, 2)
problem <- mle_problem(
  loglike = function(theta) sum(dnorm(x, theta[1], theta[2], log = TRUE)),
  constraint = mle_constraint(support = function(theta) theta[2] > 0,
                              project = function(theta) c(theta[1], max(theta[2], 1e-8)))
)
# Three-stage strategy
strategy <- compose(
  grid_search(lower = c(-10, 0.1), upper = c(10, 5), n = 5),
  gradient_ascent(max_iter = 50),
  newton_raphson(max_iter = 20)
)
result <- strategy(problem, c(0, 1))
}

}
