% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_iterative_ratings}
\alias{compute_iterative_ratings}
\title{Internal function to compute iterative ratings}
\usage{
compute_iterative_ratings(rate_fun, player1_id, score1, player2_id, score2,
  initial_ratings)
}
\arguments{
\item{rate_fun}{Rating function (see Details).}

\item{player1_id}{Integer vector of player1 identifiers.}

\item{score1}{Numeric vector of player1 score in games.}

\item{player2_id}{Integer vector of player2 identifiers.}

\item{score2}{Numeric vector of player2 score in games.}

\item{initial_ratings}{Numeric vector of initial ratings (see Details).}
}
\value{
A list:
\itemize{
\item rating1Before - rating of player 1 before the game;
\item rating2Before - rating of player 2 before the game;
\item rating1After - rating of player 1 after the game;
\item rating2After - rating of player 2 after the game.
}
}
\description{
C++ implementation of iterative computations.
}
\details{
\code{rate_fun} - function that takes arguments:
\itemize{
\item rating1 - rating of player1 before game;
\item score1 - numeric score of player1 in the game;
\item rating2 - rating of player2 before game;
\item score2 - numeric score of player2 in the game.
}
This function should return numeric vector of length 2: rating of player1
and player2 after the game.

\code{player1_id}, \code{player2_id} - integer vectors of identifiers of
players in a form of increasing numbers (1, 2, ...). Identifier 0 is
reserved for 'ghost' player. His/her rating is taken as current rating of
opponent. For two 'ghost' players ratings before and after are 0.

\code{initial_ratings} - numeric vector of length equal to number of unique
players in \code{player1_id} and \code{player2_id}. In
\code{initial_ratings[player_id - 1]} (indexing from zero) initial rating of
player with identifier 'player_id' is stored.
}
\keyword{internal}
