% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{colorDF_themes_show}
\alias{colorDF_themes_show}
\title{Demonstrate all defined themes}
\usage{
colorDF_themes_show(themes = NULL, force_bg = FALSE)
}
\arguments{
\item{themes}{character vector with theme names to show}

\item{force_bg}{force background to "white" for light themes and "black" for dark themes}
}
\description{
Demonstrate all defined themes
}
\details{
"Themes" are simply predefined styles for colorful data frames. Some are
suitable only for dark or light backgrounds, so this function is useful for
choosing what looks best on your terminal.

When a colorful data frame is created with \code{\link[=colorDF]{colorDF()}} or \code{\link[=as.colorDF]{as.colorDF()}},
the default theme is assigned to it. The default theme is defined by the
option "colorDF_theme" set using \code{\link[=options]{options()}} (at startup, the default theme
is "light").

You can also specify the theme to use when making a data frame colorful
with \code{\link[=colorDF]{colorDF()}} by using the \verb{theme=} parameter.
}
\examples{
colorDF_themes_show()
colorDF_themes_show(themes=c("wb", "bw"))
}
