% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hailstone_sequence.R
\name{hailstone_sequence}
\alias{hailstone_sequence}
\title{Hailstone Sequencer}
\usage{
hailstone_sequence(
  initial_value,
  P = 2,
  a = 3,
  b = 1,
  max_total_stopping_time = 1000,
  total_stopping_time = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{initial_value}{(numeric|bigz)
The value to begin the hailstone sequence from.}

\item{P}{(numeric|bigz): Modulus used to divide
n, iff n is equivalent to (0 mod P). Default is 2.}

\item{a}{(numeric|bigz) Factor by which to multiply n. Default is 3.}

\item{b}{(numeric|bigz) Value to add
to the scaled value of n. Default is 1.}

\item{max_total_stopping_time}{(int) Maximum amount of times to iterate the
function, if 1 is not reached. Default is 1000.}

\item{total_stopping_time}{(bool) Whether or not to execute until the "total"
stopping time (number of iterations to obtain 1) rather than the regular
stopping time (number of iterations to reach a value less than the initial
value). Default is TRUE.}

\item{verbose}{(bool) If set to verbose, the hailstone sequence will include
control string sequences to provide information about how the
sequence terminated, whether by reaching a stopping time or entering
a cycle. Default is TRUE.}
}
\value{
A keyed list consisting of a $values list of numeric | bigz
along with a $terminalCondition and $terminalStatus
}
\description{
Calculates the values of a hailstone sequence, from an initial value.
}
\details{
Returns a list of successive values obtained by iterating a Collatz-esque
function, until either 1 is reached, or the total amount of iterations
exceeds max_total_stopping_time, unless total_stopping_time is FALSE, which
will terminate the hailstone at the "stopping time" value, i.e. the first
value less than the initial value. While the sequence has the capability to
determine that it has encountered a cycle, the cycle from "1" wont be
attempted or reported as part of a cycle, regardless of default or custom
parameterisation, as "1" is considered a "total stop".
}
\examples{
# Compute a hailstone sequence, which defaults to the total stopping time;
hailstone_sequence(5)
# Or only compute down to the regular stopping time;
hailstone_sequence(5, total_stopping_time=FALSE)
# Remove verbose messaging;
hailstone_sequence(5, verbose=FALSE)
# It will also stop on finding a cycle;
hailstone_sequence(-56)
# And can be parameterised;
hailstone_sequence(3, -1, 3, 1)
# The hailstone sequence can run on `bigz`;
hailstone_sequence(27+as.bigz("576460752303423488"))
}
