% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_for_datasets.R
\docType{data}
\name{rxriskv}
\alias{rxriskv}
\title{Classcodes for RxRisk V based on ATC codes}
\format{
Data frames with 46 rows and 6 variables:
\describe{
\item{group}{medical condition}
\item{pratt}{ATC codes from table 1 in Pratt et al. 2018
(ignoring PBS item codes and extra conditions).}
\item{garland}{Modified version by Anne
Garland to resemble medical use in Sweden 2016 (Unpublished).}
\item{caughey}{From appendix 1 in Caughey et al. 2010}
\item{pratt}{Mortality weights from table 1 in Pratt et al. 2018}
\item{sum_all}{Unweighted count of all conditions.}
}
}
\usage{
rxriskv
}
\description{
Note that desired implementation might differ over time and by country.
}
\references{
Caughey GE, Roughead EE, Vitry AI, McDermott RA, Shakib S, Gilbert AL.
Comorbidity in the elderly with diabetes:
Identification of areas of potential treatment conflicts.
Diabetes Res Clin Pract 2010;87:385–93.

Pratt NL, Kerr M, Barratt JD, Kemp-Casey A, Kalisch Ellett LM,
Ramsay E, et al.
The validity of the Rx-Risk Comorbidity Index using medicines mapped to
the Anatomical Therapeutic Chemical (ATC) Classification System.
BMJ Open 2018;8.
}
\seealso{
Other default classcodes: 
\code{\link{ae}},
\code{\link{charlson}},
\code{\link{cps}},
\code{\link{elixhauser}},
\code{\link{hip_ae_hailer}}
}
\concept{default classcodes}
\keyword{datasets}
