% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_lm_quantities.R
\name{extract_lm_quantities}
\alias{extract_lm_quantities}
\title{Extract critical quantities from a lm object (for confidence interval calculations)}
\usage{
extract_lm_quantities(lm_X, alpha = 0.05)
}
\arguments{
\item{lm_X}{a lm object}

\item{alpha}{level of significance. Defaults to 0.05.}
}
\value{
A list containing the \code{lm} model matrix (\code{dmX}), 
the inverse of \code{t(dmX) x dmX} (\code{XtX_inv}), 
the standard error (\code{s_e}),
the estimated single column beta matrix (\code{beta_hat}), and
the critical value of the relevant degrees of freedom t-dist (\code{crit_val}).
}
\description{
Extract critical quantities from a lm object (for confidence interval calculations)
}
