% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats_aov.R
\name{format_stats.aov}
\alias{format_stats.aov}
\title{Format ANOVA statistics}
\usage{
\method{format_stats}{aov}(
  x,
  term,
  digits = 1,
  pdigits = 3,
  pzero = FALSE,
  italics = TRUE,
  dfs = "par",
  type = "md",
  ...
)
}
\arguments{
\item{x}{An \code{aov} object from \code{\link[stats:aov]{stats::aov()}}.}

\item{term}{Character string for row name of term to extract statistics for.
This must be the exact string returned in the \code{summary()} output from the
\code{aov} object.}

\item{digits}{Number of digits after the decimal for means, confidence
intervals, and test statistics.}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values).}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values.}

\item{italics}{Logical value (default = TRUE) for whether \emph{p} label should be
italicized.}

\item{dfs}{Formatting for degrees of freedom ("par" = parenthetical,
"sub" = subscript, "none" = do not print degrees of freedom).}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This method formats analysis of variance (ANOVA) statistics from the class
\code{aov}. The default output is APA formatted, but this function allows control
over numbers of digits, leading zeros, italics, degrees of freedom,
and output format of Markdown or LaTeX.
}
\examples{
test_aov <- aov(mpg ~ cyl * hp, data = mtcars)

# Format ANOVA
format_stats(test_aov, term = "cyl")

# Remove italics and make degrees of freedom subscripts
format_stats(test_aov, term = "cyl", italics = FALSE, dfs = "sub")

# Change digits and add leading zero to p-value
format_stats(test_aov, term = "hp", digits = 3, pdigits = 4, pzero = TRUE)

# Format for LaTeX
format_stats(test_aov, term = "hp", type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_chisq}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lm}()},
\code{\link{format_stats.lmerModLmerTest}()},
\code{\link{format_stats.merMod}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
