% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{compute_score_metrics}
\alias{compute_score_metrics}
\title{Compute Different Metrics Based on Scores}
\usage{
compute_score_metrics(
  land1,
  land2,
  score,
  addNA = TRUE,
  na.rm = TRUE,
  include = NULL,
  out_names = NULL
)
}
\arguments{
\item{land1}{(numeric) vector with land ids of bullet 1}

\item{land2}{(numeric) vector with land ids of bullet 2}

\item{score}{numeric vector of scores to be summarized into a single number}

\item{addNA}{logical value. In case of missing lands, are scores set to 0 (addNA = FALSE) or set to NA (addNA = TRUE)}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds}

\item{include}{a character vector specifying which metrics to be included in the result; if \code{include = NULL}, including
all metrics}

\item{out_names}{a character vector specifying the variable names of each metric; if \code{out_names = NULL}, using the default names}
}
\value{
a data frame containing values of the metrics
}
\description{
Compute Different Metrics Based on Scores
}
\details{
By default, this helper function computes four metrics.

\code{diff}: the difference between the mean score of the foreground phase and the mean score of the background phases
\code{diff.med}: the difference between the median score of the foreground phase and the median score of the background phases
\code{max}: the max score
\code{maxbar}: the mean score of the foreground phase
}
\examples{
library(tidyverse)

data("bullets")

lands <- unique(bullets$bulletland)

comparisons <- data.frame(expand.grid(land1 = lands[1:6], land2 = lands[7:12]),
                          stringsAsFactors = FALSE)

comparisons <- comparisons \%>\%
  left_join(bullets \%>\% select(bulletland, sig1=sigs),
            by = c("land1" = "bulletland")) \%>\%
  left_join(bullets \%>\% select(bulletland, sig2=sigs),
            by = c("land2" = "bulletland"))

comparisons <- comparisons \%>\% mutate(
  cmps = purrr::map2(sig1, sig2, .f = function(x, y) {
    extract_feature_cmps(x$sig, y$sig, include = "full_result")
  })
)

comparisons <- comparisons \%>\%
  mutate(
    cmps_score = sapply(comparisons$cmps, function(x) x$CMPS_score),
    cmps_nseg = sapply(comparisons$cmps, function(x) x$nseg)
  )
  
cp1 <- comparisons \%>\% select(land1, land2, cmps_score, cmps_nseg)
cp1 <- cp1 \%>\% mutate(
  land1idx = land1 \%>\% str_sub(-1, -1) \%>\% as.numeric(),
  land2idx = land2 \%>\% str_sub(-1, -1) \%>\% as.numeric()
)

with(cp1, {
  compute_score_metrics(land1idx, land2idx, cmps_score)
})
}
