% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dcmgnd}
\alias{dcmgnd}
\title{Marginal Density Estimation for CMGND Models}
\usage{
dcmgnd(x, parameters)
}
\arguments{
\item{x}{A numeric vector representing the observed data points.}

\item{parameters}{A matrix or data.frame containing the parameters of the CMGND model.
This can also be an object returned from the `cmgnd()` function, representing a previously estimated CMGND model.}
}
\value{
A vector of density estimates corresponding to the input data `x`.
}
\description{
This function estimates the marginal density for univariate constrained
mixture of generalized normal distribution (CMGND) models.
}
\details{
The function computes the marginal density based on the provided parameters of the CMGND model.
It can handle both newly supplied parameters or those extracted from an existing CMGND model object.
}
\seealso{
`cmgnd()` for estimating the model parameters.
}
