% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{start_groups}
\alias{start_groups}
\title{Function to assign starting groups.}
\usage{
start_groups(k, data, starts, maxdf, conv, mccores = 1, verbose = FALSE)
}
\arguments{
\item{k}{Number of clusters (groups).}

\item{data}{Data.table with response measurements, one per observation.
Column names are id, time, response, group. Note that \code{id}s are assumed
sequential starting from 1. This affects expanding group numbers to ids.}

\item{starts}{Type of start groups generated. See \code{\link{clustra}}.}

\item{maxdf}{Fitting parameters. See \code{\link{trajectories}}.}

\item{conv}{Fitting parameters. See \code{\link{trajectories}}.}

\item{mccores}{See \code{\link{trajectories}}.}

\item{verbose}{Turn on more output for debugging. Values 0, 1, 2, 3 add more output. 2 and
3 produce graphs during iterations - use carefully!}
}
\value{
An integer vector corresponding to unique \code{id}s, giving group number
assignments.

For \code{distant}, each sequential selection takes an id that has the largest
minimum distance from smooth TPS fits (<= 5 deg) of previous selections.
The distance of an id to a single TPS is the median absolute error across
the id time points. Distance of an id to a set of TPS is the minimum of
the individual distances. We pick the id that has the maximum of such
a minimum of medians.
}
\description{
Either a random assignment of k approximately equal size clusters or a
FastMap-like algorithm that sequentially selects k distant ids
from those that have more than the median number of observations. TPS fits
to these ids are used as cluster centers for a starting group assignment.
A user supplied starting assignment is also possible.
}
