% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siteFrequency.R
\name{siteFrequency}
\alias{siteFrequency}
\title{Get site frequency spectrum of a tree}
\usage{
siteFrequency(tree, includeStem = FALSE)
}
\arguments{
\item{tree}{An ultrametric or mutation-based tree subset to include only the
clone of interest. Alternatively, a list with several such trees.}

\item{includeStem}{Boolean indicating whether we should count the stem of the
tree as contributing to the site frequency distribution. Default is FALSE.}
}
\value{
A data.frame with three columns: the number of descendant cells, site
frequency in units of time or mutations, and normalized site frequency. If a
list of trees is input, output will be a list of such data.frames.
}
\description{
\code{siteFrequency()} calculates the site frequency in
units of time or mutations, as well as a normalized frequency.
}
\examples{
# Get site frequency of a single tree
example.df <- siteFrequency(exampleUltraTrees[[1]])

# Get site frequency of a list of trees
example.list <- siteFrequency(exampleMutTrees)

}
\seealso{
\code{\link[=internalLengths]{internalLengths()}} and \code{\link[=sharedMuts]{sharedMuts()}} which
use the sum of edge lengths ancestral to between 2 and n-1 tips to calculate
a growth rate.
}
