% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realData.R
\docType{data}
\name{longitudinalData}
\alias{longitudinalData}
\title{Longitudinal validation data}
\format{
A \code{data.frame} containing all the information needed
\describe{
\item{Sample.ID}{The individual's ID}
\item{Age}{Individual's age at the various sampling times}
\item{VAF}{The variant allele frequency at the various sampling times for the clone of interest}
\item{Gene}{Gene or genes with mutation that identifies the clone}
\item{Protein}{Protein affected by the mutation}
\item{cellType}{The type of cells used for sequencing}
\item{cloneName}{The name we use for the clone to match to single cell data, if applicable.}
}
}
\usage{
longitudinalData
}
\description{
For three individuals with clonal expansions that can be estimated using our methods,
we have longitudinal data to orthogonally validate these estimates, which is included here.
Additionally, for 13 clones with a driver gene matching a driver gene in the single cell
data, but without a match to a specific clone, we include this longitudinal data as well.
}
\examples{
# Plot longitudinal data from PD9478
library(ggplot2)
ggplot(longitudinalData[longitudinalData$Sample.ID == "PD9478", ]) +
  geom_point(aes(x = Age, y = VAF))
}
\references{
These datasets were generated and annotated in:
\href{https://pubmed.ncbi.nlm.nih.gov/35058638/}{Williams et al. 2022}
\href{https://pubmed.ncbi.nlm.nih.gov/35650444/}{Fabre et al. 2022}
}
\keyword{longitudinal}
