% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleData.R
\docType{data}
\name{exampleUltraTrees}
\alias{exampleUltraTrees}
\title{Example ultrametric tree data}
\format{
A \code{list} of objects of class \code{phylo}
\describe{
\item{edge}{A matrix of edge connections which reconstruct the tree.}
\item{edge.length}{A numeric vector of the branch lengths of the connections
in \code{edge} matrix. Units are years.}
\item{tip.label}{A character vector containing the  (arbitrary in this case)
labels for the 100 tips/samples of the tree.}
\item{Nnode}{Integer number of internal nodes of the tree}
\item{params}{\code{data.frame} containing info on the params used to generate
the tree}
See ape package for details on class \code{phylo} objects.
}
}
\usage{
data(exampleUltraTrees)
}
\description{
Set of 100 time-based ultrametric trees reconstructed from the distribution
of a sample of n=100 tips.
All trees have a net growth rate of 1 with birth rates between 1 and 2
(sampled from a uniform distribution). Death rates are equal to the chosen
birth rate minus 1. Tree reconstruction uses the exact distribution of
coalescence times described in "The coalescent of a sample from a binary
branching process", Lambert A., Theor. Pop. Bio. 2018. Tree construction and
formatting uses \code{ape} R package \code{\link[ape:rtree]{ape::rcoal()}}.
}
\examples{
# Plot first of 100 trees
ape::plot.phylo(cloneRate::exampleUltraTrees[[1]],
  direction = "downwards", show.tip.label = FALSE
)
}
\references{
This data set was created for the cloneRate package using
coalescent theory approaches described in "The coalescent of a sample from a
binary branching process", Lambert A., Theor. Pop. Bio. 2018.
}
\keyword{datasets}
